/*
 * Decompiled with CFR 0.152.
 */
package mekanism.common.integration.lookingat.hwyla;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.Accessor;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.EntityAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.Element;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.FloatingLong;
import mekanism.common.Mekanism;
import mekanism.common.integration.lookingat.ChemicalElement;
import mekanism.common.integration.lookingat.EnergyElement;
import mekanism.common.integration.lookingat.FluidElement;
import mekanism.common.integration.lookingat.LookingAtElement;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.fluids.FluidStack;

public class HwylaTooltipRenderer
implements IComponentProvider,
IEntityComponentProvider {
    static final ResourceLocation ENERGY = Mekanism.rl("energy");
    static final ResourceLocation FLUID = Mekanism.rl("fluid");
    static final ResourceLocation GAS = Mekanism.rl("gas");
    static final ResourceLocation INFUSE_TYPE = Mekanism.rl("infuse_type");
    static final ResourceLocation PIGMENT = Mekanism.rl("pigment");
    static final ResourceLocation SLURRY = Mekanism.rl("slurry");
    static final HwylaTooltipRenderer INSTANCE = new HwylaTooltipRenderer();

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        this.append(tooltip, (Accessor<?>)accessor, config);
    }

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        this.append(tooltip, (Accessor<?>)accessor, config);
    }

    private void append(ITooltip tooltip, Accessor<?> accessor, IPluginConfig config) {
        CompoundTag data = accessor.getServerData();
        if (data.m_128425_("mekData", 9)) {
            MutableComponent lastText = null;
            ListTag list = data.m_128437_("mekData", 10);
            for (int i = 0; i < list.size(); ++i) {
                ResourceLocation name;
                LookingAtElement element;
                CompoundTag elementData = list.m_128728_(i);
                if (elementData.m_128425_("text", 8)) {
                    MutableComponent text = Component.Serializer.m_130701_((String)elementData.m_128461_("text"));
                    if (text == null) continue;
                    if (lastText != null) {
                        tooltip.add((Component)lastText);
                    }
                    lastText = text;
                    continue;
                }
                if (elementData.m_128425_("energy", 8)) {
                    element = new EnergyElement(FloatingLong.parseFloatingLong(elementData.m_128461_("energy"), true), FloatingLong.parseFloatingLong(elementData.m_128461_("max"), true));
                    name = ENERGY;
                } else if (elementData.m_128425_("fluid", 10)) {
                    element = new FluidElement(FluidStack.loadFluidStackFromNBT((CompoundTag)elementData.m_128469_("fluid")), elementData.m_128451_("max"));
                    name = FLUID;
                } else {
                    ChemicalStack chemicalStack;
                    if (!elementData.m_128425_("chemical", 10)) continue;
                    CompoundTag chemicalData = elementData.m_128469_("chemical");
                    if (chemicalData.m_128425_("gasName", 8)) {
                        chemicalStack = GasStack.readFromNBT(chemicalData);
                        name = GAS;
                    } else if (chemicalData.m_128425_("infuseTypeName", 8)) {
                        chemicalStack = InfusionStack.readFromNBT(chemicalData);
                        name = INFUSE_TYPE;
                    } else if (chemicalData.m_128425_("pigmentName", 8)) {
                        chemicalStack = PigmentStack.readFromNBT(chemicalData);
                        name = PIGMENT;
                    } else {
                        if (!chemicalData.m_128425_("slurryName", 8)) continue;
                        chemicalStack = SlurryStack.readFromNBT(chemicalData);
                        name = SLURRY;
                    }
                    element = new ChemicalElement(chemicalStack, elementData.m_128454_("max"));
                }
                if (config.get(name)) {
                    tooltip.add(new MekElement((Component)lastText, element).tag(name));
                }
                lastText = null;
            }
            if (lastText != null) {
                tooltip.add(lastText);
            }
        }
    }

    private static class MekElement
    extends Element {
        @Nullable
        private final Component text;
        private final LookingAtElement element;

        public MekElement(@Nullable Component text, LookingAtElement element) {
            this.element = element;
            this.text = text;
        }

        public Vec2 getSize() {
            int width = this.element.getWidth();
            int height = this.element.getHeight() + 2;
            if (this.text != null) {
                width = Math.max(width, 96);
                height += 14;
            }
            return new Vec2((float)width, (float)height);
        }

        public void render(PoseStack poseStack, float x, float y, float maxX, float maxY) {
            if (this.text != null) {
                LookingAtElement.renderScaledText(Minecraft.m_91087_(), poseStack, x + 4.0f, y + 3.0f, 0xFFFFFF, 92.0f, this.text);
                y += 13.0f;
            }
            poseStack.m_85836_();
            poseStack.m_85837_((double)x, (double)y, 0.0);
            this.element.render(poseStack, 0, 1);
            poseStack.m_85849_();
        }
    }
}

